VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3120
   ClientLeft      =   60
   ClientTop       =   420
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3120
   ScaleWidth      =   4680
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   960
      TabIndex        =   0
      Top             =   960
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long

Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' Try to continue
End Sub

Private Sub Command1_Click()
   Dim a As Long, d As Double, w As Double
   Call pdf.CreateNewPDF(vbNullString)  ' The ouput file is opened later

   Call pdf.SetPageCoords(pcTopDown)

   Call pdf.Append
      Call pdf.SaveGraphicState
         Call pdf.SetGStateFlags(TGStateFlags.gfRealTopDownCoords, False) ' This simplifies the handling a little bit.
         Call pdf.RotateCoords(-30, 50#, 200#)

         Dim Text As String
         Text = "Some rotated text on a page..."
         Call pdf.SetFont("Helvetica", TFStyle.fsRegular, 20#, False, TCodepage.cp1252)

         d = pdf.GetDescent()
         w = pdf.GetTextWidth(Text)

         ' Highlight annotations do not consider coordinate transformations made on a page.
         ' To get such annotations rotated we must set the annotation's quad points.
         ' SetAnnotQuadPoints() considers transformations of the coordinate system.

         Call pdf.WriteText(0#, 0#, Text)
         a = pdf.HighlightAnnot(TAnnotType.atHighlight, 50#, 50# + d, w, 20#, PDF_YELLOW, "Test app", "Highligh Annotations", "This is a highlight annotation")
         Dim points() As TFltPoint
         ReDim points(3)
         ' Consider the unusual order of the points!
         points(0).x = 0#       ' x1 -> Top left corner
         points(0).y = d        ' y1 -> Top left corner
         points(1).x = w        ' x2 -> Top right corner
         points(1).y = d        ' y2 -> Top right corner
         points(2).x = 0#       ' x3 -> Bottom left corner
         points(2).y = 20# + d  ' y3 -> Bottom left corner
         points(3).x = w        ' x4 -> Bottom right corner
         points(3).y = 20# + d  ' y4 -> Bottom right corner
         Call pdf.SetAnnotQuadPoints(a, points)

         Call pdf.WriteText(0#, 30#, Text)
         a = pdf.HighlightAnnot(TAnnotType.atSquiggly, 50#, 80#, w, 20#, PDF_RED, "Test app", "Squiggly Annotations", "This is a squiggly annotation")
         ' Update the y-coordinates
         points(0).y = points(0).y + 30#
         points(1).y = points(1).y + 30#
         points(2).y = points(2).y + 30#
         points(3).y = points(3).y + 30#
         Call pdf.SetAnnotQuadPoints(a, points)

         Call pdf.WriteText(0#, 60#, Text)
         a = pdf.HighlightAnnot(TAnnotType.atStrikeOut, 50#, 110#, w, 20#, PDF_RED, "Test app", "Strikeout Annotations", "This is a strikeout annotation")
         ' Update the y-coordinates
         points(0).y = points(0).y + 30#
         points(1).y = points(1).y + 30#
         points(2).y = points(2).y + 30#
         points(3).y = points(3).y + 30#
         Call pdf.SetAnnotQuadPoints(a, points)

         Call pdf.WriteText(0#, 90#, Text)
         a = pdf.HighlightAnnot(TAnnotType.atUnderline, 50#, 140#, w, 20#, PDF_RED, "Test app", "Underline Annotations", "This is a underline annotation")
         ' Update the y-coordinates
         points(0).y = points(0).y + 30#
         points(1).y = points(1).y + 30#
         points(2).y = points(2).y + 30#
         points(3).y = points(3).y + 30#
         Call pdf.SetAnnotQuadPoints(a, points)

         Text = "Link annotations support quad points too"
         w = pdf.GetTextWidth(Text)
         Call pdf.WriteText(0#, 120#, Text)
         ' Link annotations support quad points too.
         a = pdf.WebLink(0#, 120#, w, 20, "www.dynaforms.com")
         Call pdf.SetAnnotBorderWidth(a, 1#)
         Call pdf.SetAnnotColor(a, TAnnotColor.acBorderColor, TPDFColorSpace.csDeviceRGB, PDF_BLUE)
         points(0).x = 0#        ' x1 -> Top left corner
         points(0).y = 120# + d  ' y1 -> Top left corner
         points(1).x = w         ' x2 -> Top right corner
         points(1).y = 120# + d  ' y2 -> Top right corner
         points(2).x = 0#        ' x3 -> Bottom left corner
         points(2).y = 140# + d  ' y3 -> Bottom left corner
         points(3).x = w         ' x4 -> Bottom right corner
         points(3).y = 140# + d  ' y4 -> Bottom right corner
         Call pdf.SetAnnotQuadPoints(a, points)
      Call pdf.RestoreGraphicState
   Call pdf.EndPage

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim outFile As String
      outFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(outFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", outFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub
